<?php 
require 'Prozigzig.php';
$h = new Prozigzig();
header('Content-type: application/json');
$data = json_decode(file_get_contents('php://input'), true);

if (
    empty($data['operator_id']) || 
    empty($data['bus_id']) || 
    empty($data['trip_date']) || 
    empty($data['sender_name']) || 
    empty($data['sender_mobile']) || 
    empty($data['receiver_name']) || 
    empty($data['receiver_mobile']) || 
    empty($data['from_city']) || 
    empty($data['to_city']) || 
    empty($data['parcel_weight']) || 
    empty($data['price'])
) {
    $returnArr = array("ResponseCode" => "401", "Result" => "false", "ResponseMsg" => "Missing required fields!");
    echo json_encode($returnArr);
    exit;
}

// Assign input
$uid = intval($data['uid']);
$price_per_km = intval($data['price_per_km']);
$distance = intval($data['distance']);
$operator_id = intval($data['operator_id']);
$bus_id = intval($data['bus_id']);
$trip_date = $data['trip_date'];
$sender_name = $h->real_string($data['sender_name']);
$sender_mobile = $h->real_string($data['sender_mobile']);
$receiver_name = $h->real_string($data['receiver_name']);
$receiver_mobile = $h->real_string($data['receiver_mobile']);
$from_city = $h->real_string($data['from_city']);
$to_city = $h->real_string($data['to_city']);
$p_method_id = $h->real_string($data['p_method_id']);
$transaction_id = $h->real_string($data['transaction_id']);
$from_point_id = $h->real_string($data['from_point_id']);
$to_point_id = $h->real_string($data['to_point_id']);
$parcel_weight = floatval($data['parcel_weight']);
$wall_amt = floatval($data['wall_amt']);
$price = floatval($data['price']);
$getcommission = $h->queryfire("select admin_pacel_commission from tbl_setting")->fetch_assoc();
$admin_pacel_commission = $getcommission['admin_pacel_commission']/100;
// Commission Calculation (example: 10% admin)
$calc_price = ($price == 0) ? $wall_amt : $price;

// Commission Calculation
$admin_commission = round($calc_price * $admin_pacel_commission, 2);
$vendor_earning = round($calc_price - $admin_commission, 2);
$timestamp = date("Y-m-d H:i:s");
// Prepare insert fields
$field_values = array(
    "operator_id", "bus_id", "trip_date", 
    "sender_name", "sender_mobile", 
    "receiver_name", "receiver_mobile", 
    "from_city", "to_city", 
    "parcel_weight", "price", 
    "admin_commission", "vendor_earning", "created_at","uid","price_per_km","distance","to_point_id","from_point_id","p_method_id","transaction_id", "wall_amt"
);

$data_values = array(
    $operator_id, $bus_id, $trip_date, 
    $sender_name, $sender_mobile, 
    $receiver_name, $receiver_mobile, 
    $from_city, $to_city, 
    $parcel_weight, $price, 
    $admin_commission, $vendor_earning, $timestamp,$uid,$price_per_km,$distance,$to_point_id,$from_point_id,$p_method_id,$transaction_id,$wall_amt
);

// Insert into tbl_parcel
$insert = $h->insertDataId_Api($field_values, $data_values, "tbl_parcel");

if($wall_amt != 0)
{
 $vp = $h->queryfire("select * from tbl_user where id=".$uid."")->fetch_assoc();
	  $mt = intval($vp['wallet'])-intval($wall_amt);
  $table="tbl_user";
  $field = array('wallet'=>"$mt");
  $where = "where id=".$uid."";
	  $check = $h->updateData_Api($field,$table,$where);
	  $tdate = date("Y-m-d");
	  $table="wallet_report";
  $field_values=array("uid","message","status","amt","tdate");
  $data_values=array("$uid",'Wallet Used in Book Parcel Id#'.$insert,'Debit',"$wall_amt","$tdate");
	  $checks = $h->insertData_Api($field_values,$data_values,$table);
}

if ($insert) {
    $returnArr = array(
        "ResponseCode" => "200",
        "Result" => "true",
        "ResponseMsg" => "Parcel booked successfully!"
    );
} else {
    $returnArr = array(
        "ResponseCode" => "500",
        "Result" => "false",
        "ResponseMsg" => "Failed to book parcel."
    );
}

echo json_encode($returnArr);
